/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host.html;

import com.gargoylesoftware.htmlunit.BrowserVersion;
import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.HtmlKeygen;
import com.gargoylesoftware.htmlunit.html.HtmlSpan;
import com.gargoylesoftware.htmlunit.javascript.configuration.BrowserName;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClasses;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxConstructor;
import com.gargoylesoftware.htmlunit.javascript.configuration.WebBrowser;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLElement;
import java.util.Locale;

@JsxClasses(value={@JsxClass(domClass=HtmlSpan.class), @JsxClass(domClass=HtmlKeygen.class, browsers={@WebBrowser(value=BrowserName.FF)})})
public class HTMLSpanElement
extends HTMLElement {
    private boolean endTagForbidden_;

    @JsxConstructor(value={@WebBrowser(value=BrowserName.CHROME), @WebBrowser(value=BrowserName.FF), @WebBrowser(value=BrowserName.EDGE)})
    public HTMLSpanElement() {
    }

    @Override
    public void setDomNode(DomNode domNode) {
        super.setDomNode(domNode);
        BrowserVersion browser = this.getBrowserVersion();
        if (browser.hasFeature(BrowserVersionFeatures.HTMLBASEFONT_END_TAG_FORBIDDEN)) {
            switch (domNode.getLocalName().toLowerCase(Locale.ROOT)) {
                case "basefont": 
                case "keygen": {
                    this.endTagForbidden_ = true;
                    break;
                }
            }
        }
    }

    public String getCite() {
        String cite = this.getDomNodeOrDie().getAttribute("cite");
        return cite;
    }

    public void setCite(String cite) {
        this.getDomNodeOrDie().setAttribute("cite", cite);
    }

    public String getDateTime() {
        String dateTime = this.getDomNodeOrDie().getAttribute("datetime");
        return dateTime;
    }

    public void setDateTime(String dateTime) {
        this.getDomNodeOrDie().setAttribute("datetime", dateTime);
    }

    @Override
    protected boolean isLowerCaseInOuterHtml() {
        return super.isLowerCaseInOuterHtml();
    }

    @Override
    protected boolean isEndTagForbidden() {
        return this.endTagForbidden_;
    }
}

