/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript;

import java.lang.reflect.Method;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import net.sourceforge.htmlunit.corejs.javascript.FunctionObject;
import net.sourceforge.htmlunit.corejs.javascript.Scriptable;
import net.sourceforge.htmlunit.corejs.javascript.ScriptableObject;

public class HtmlUnitScriptable
extends ScriptableObject {
    private String className_;

    @Override
    public String getClassName() {
        if (this.className_ != null) {
            return this.className_;
        }
        if (this.getPrototype() != null) {
            return this.getPrototype().getClassName();
        }
        String className = this.getClass().getSimpleName();
        if (className.isEmpty()) {
            className = this.getClass().getSuperclass().getSimpleName();
        }
        return className;
    }

    public void setClassName(String className) {
        this.className_ = className;
    }

    @Override
    public void defineProperty(String propertyName, Class<?> clazz, int attributes) {
        int length = propertyName.length();
        if (length == 0) {
            throw new IllegalArgumentException();
        }
        char[] buf = new char[3 + length];
        propertyName.getChars(0, length, buf, 3);
        buf[3] = Character.toUpperCase(buf[3]);
        buf[0] = 103;
        buf[1] = 101;
        buf[2] = 116;
        String getterName = new String(buf);
        buf[0] = 115;
        String setterName = new String(buf);
        Method[] methods = clazz.getMethods();
        Method getter = HtmlUnitScriptable.findMethod(methods, getterName);
        Method setter = HtmlUnitScriptable.findMethod(methods, setterName);
        if (setter == null) {
            attributes |= 1;
        }
        this.defineProperty(propertyName, null, getter, setter, attributes);
    }

    @Override
    public void defineFunctionProperties(String[] names, Class<?> clazz, int attributes) {
        Method[] methods = clazz.getMethods();
        for (String name : names) {
            Method method = HtmlUnitScriptable.findMethod(methods, name);
            if (method == null) {
                throw Context.reportRuntimeError("Method \"" + name + "\" not found in \"" + clazz.getName() + '\"');
            }
            FunctionObject f = new FunctionObject(name, method, this);
            this.defineProperty(name, f, attributes);
        }
    }

    private static Method findMethod(Method[] methods, String name) {
        for (Method m : methods) {
            if (!m.getName().equals(name)) continue;
            return m;
        }
        return null;
    }

    @Override
    public void setParentScope(Scriptable m) {
        if (m == this) {
            throw new IllegalArgumentException("Object can't be its own parentScope");
        }
        super.setParentScope(m);
    }

    @Override
    public Object getDefaultValue(Class<?> typeHint) {
        return "[object " + this.getClassName() + "]";
    }
}

